
/**
 * class Datum - Beschrijft een geldige datum.
 * Men mag ervan uitgaan dat februari steeds 28 dagen heeft.
 * Men mag ervan uitgaan dat het jaar uit vier cijfers bestaat.
 *
 * @author Dominiek Vandewalle
 * @version 2017-11-15
 */
public class Datum
{
    private int dag;
    private int maand;
    private int jaar;
    
    /**
     * Constructor voor objecten van de klasse Datum
     * @param   dag     De dag in de maand.
     * @param   maand   De maand in het jaar.
     * @param   jaar    Het jaar.
     */
    public Datum(int dag, int maand, int jaar)
    {
        this.dag = dag;
        this.maand = maand;
        this.jaar = jaar;
    }
    
    /**
     * Geeft het aantal dagen in de huidige maand terug.
     * @return  aantal dagen in de huidige maand.
     */
    public int aantalDagenInMaand()
    {
        int dagen = 31;
        
        switch(maand)
        {
            case 4:
            case 6:
            case 9:
            case 11:
                dagen = 30;
            case 2:
                dagen = 28;
        }
        
        return dagen;
    }
    
    /**
     * Geeft aan of de gegeven datum geldig is.
     * @return  True indien de datum geldig is, anders false.
     */
    public boolean geldigeDatum()
    {
        boolean isGeldig = true;
        
        if(dag < 1 || dag > 31)
        {
            isGeldig = false;
        }
        
        if(maand < 1 || maand > 12)
        {
            isGeldig = false;
        }
        
        if(String.valueOf(jaar).length() != 4)
        {
            isGeldig = false;
        }
        
        return isGeldig;
    }
    
    /**
     * Laat de datum 1 dag vooruit gaan.
     */
    public void volgendeDag()
    {
        dag++;
        
        if(dag == aantalDagenInMaand())
        {
            maand++;
        }
    }
}
